state EyeOfTheStorm in W3MagicVigil
{
	var damage_action			 						: W3DamageAction;
	var damage_value									: float;
	var actors 											: array<CActor>;
	var i												: int;
	var main_effect, effect_entity  					: CEntity;
	var target											: CActor; 
	var entities 										: array<CGameplayEntity>; 
	var position 										: Vector;
	var rotation 										: EulerAngles;
	var slotMatrix 										: Matrix;
	var energy_area   									: SpellsEnergyArea;
	var ents_destroy									: array< CEntity >;
	var duration										: float;
	var CustomEffect									: SCustomEffectParams;
	var castDir											: Vector;
	var targetPosition									: Vector;
	var fireball										: W3FireGnosisFireball;
	var boneRotation 									: EulerAngles;
	var bonePosition 									: Vector;
	var dummy											: CEntity;
	var dummy_proj                                      : W3EnergyDummy;
	var custom_anim										: name;
	var cast_hand										: CEntity;
	var vector_attach 									: Vector;
	var randRoll										: float;


	event OnEnterState( prevStateName : name )
	{
		if ( !theSound.SoundIsBankLoaded("magic_yennefer.bnk") )
		{
			theSound.SoundLoadBank( "magic_yennefer.bnk", false );
		}
	
		if ( parent.act_signtype == ST_Axii )
		{
			if ( parent.actor && parent.actor.IsAlive() )
			{
				thePlayer.SetSlideTarget( parent.actor );
			}
			else
			{
				thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
			}
		}
		else
		if ( !theGame.GetInGameConfigWrapper().GetVarValue('magic_spells_main', 'cast_to_camera') )
		{
			if ( !GetMagicVigil().IsAlt() )
			{
				if ( parent.actor && parent.actor.IsAlive() )
				{
					thePlayer.SetSlideTarget( parent.actor );
				}
				else
				{
					thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
				}
			}
		}
		else
		{
			thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
		}
		
		if ( parent.alternate )
		{
			thePlayer.PushState( 'camera_hack' );     
		}
	}
	
	event OnCastSpellAnimation( animEventName : name, animEventType : EAnimationEventType, animInfo : SAnimationEventAnimInfo )
	{
		if ( animEventName == 'cast_begin' )
		{
		}
		else if ( animEventName == 'cast_throw' )
		{
			cast_spells_stormeye();
		}
		else if ( animEventName == 'cast_end' )
		{
			parent.GotoState( 'Vigil_Dreaming' );
		}
	}
	
	private function cast_spells_stormeye()
	{
		switch( parent.spell_name )
		{
			case 'storm_slow':
				{
					duration = 5;
					duration += duration * ( get_spellpower_spells( true ) * 0.5 );
					
					//theGame.witcherLog.AddMessage("DURATION  =  " + duration);
				
					CustomEffect.effectType = EET_EyeOfTheStorm;
					CustomEffect.creator = GetWitcherPlayer();
					CustomEffect.duration = duration;
					GetWitcherPlayer().AddEffectCustom( CustomEffect );
					
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
					
					thePlayer.SoundEvent("magic_yennefer_q310_spell_01");
					
					theGame.GetEntityByTag('storm_eye_effect').PlayEffect('storm_eye');
					theGame.GetEntityByTag('storm_eye_effect').StopEffect('storm_eye');
				}

				break;
			default:		
				break;
		}
	}
	
	event OnLeaveState( nextStateName : name )
	{
	}
}


statemachine class StormEyeSpell extends CGameplayEntity
{
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		GotoState('Eye_of_the_storm_state');
		
		//thePlayer.AddAnimEventChildCallback(this,	'SlowMo',							'OnAnimEvent_SlowMo_spells');
	}
	
	/*
	event OnAnimEvent_SlowMo_spells( animEventName : name, animEventType : EAnimationEventType, animInfo : SAnimationEventAnimInfo )
	{
		theGame.RemoveTimeScale( 'AnimEventSlomoMo' );	
	}
	*/

	event OnDestroyed()
	{
	}
}

state Eye_of_the_storm_state in StormEyeSpell
{	
	var i					: int;
	var speed				: float;
	var actor				: CActor;
	var actors				: array<CActor>;
	var slowdown 			: float;
	var storm_slowdown		: array<int>;

	event OnEnterState( prevStateName : name )
	{
		slowdown = 0.7 - ( get_spellpower_spells( true ) * 0.1 );
		slowdown = ClampF( slowdown, 0.3, 0.7 );	
		//theGame.witcherLog.AddMessage("SPELL POWER: " + ( get_spellpower_spells( true ) * 0.1 ) );
		//theGame.witcherLog.AddMessage("SLOWDOWN: " + slowdown );
		theGame.SetTimeScale(slowdown, theGame.GetTimescaleSource(7), theGame.GetTimescalePriority(7) );
		//slowdown = 0.3;
		if ( storm_slowdown.Size() == 0 )
		{
			speed = 1 / slowdown;
			storm_slowdown.PushBack( thePlayer.SetAnimationSpeedMultiplier( 1 / slowdown ) );
			//theGame.witcherLog.AddMessage("PLAYER SPEED: " + ( 1 / slowdown ) );
			//theGame.witcherLog.AddMessage("PLAYER SPEED OLD: " + ( 2 - slowdown ) );
			
			GetMagicVigil().set_other_speed_mult( speed );
		}
		
		Eye_of_the_storm_state_checking();
		
		actors.Clear();
	}
	
	private entry function Eye_of_the_storm_state_checking()
	{
		while(true)
		{
			if ( theGame.GetTimeScale() != slowdown )
			{
				theGame.SetTimeScale( slowdown, theGame.GetTimescaleSource(7), theGame.GetTimescalePriority(7) );	
			}	
			
			actor = ((CActor) thePlayer.GetDisplayTarget());
			if ( !actor.HasAbility('DisableFinishers') )
			{
				actor.AddAbility( 'DisableFinishers', false );
				actors.PushBack(actor);
			}
			Sleep(0.1);
		}
	}
	
	event OnLeaveState( nextStateName : name )
	{
		theGame.RemoveTimeScale( theGame.GetTimescaleSource(7) );
		
		for( i=0; i<storm_slowdown.Size(); i+=1 )
		{
			thePlayer.ResetAnimationSpeedMultiplier( storm_slowdown[i] );
		}
		storm_slowdown.Clear();
		GetMagicVigil().set_other_speed_mult( 0 );
		
		for( i=0; i<actors.Size(); i+=1 )
		{
			actors[i].RemoveAbility('DisableFinishers');
		}
	}
}